﻿  package{
	  import flash.display.*;
	  import flash.events.*;
	  import flash.net.*;
	  import flash.text.*;
	  
	  public class PreviewPanel extends MovieClip{
		  var item:ItemHolder;
		  var arrItems:Array;
		  var numItems:Number = 0;
		  var itemName:String = "";
		  var currentItemPos:Number = -1;
		  var nextItemPos:Number = -1;
		  var prevItemPos:Number = -1;
		  
		  var itemPosOnInit:Number = -1;	//position of the item on start
		  
		  //size variables
		  var dataWidth:Number;
		  var dataHeight:Number;
		  var dataX:Number;
		  var dataY:Number;
		  
		  public var mc_data:Loader = new Loader();
		  
		  //inner elements:
		  //mc_buttonPrev
		  //mc_buttonNext
		  //mc_preloader
		  //txt_numitem
		  //mc_buttonClose
		  //txt_name
		  //mc_previewArea
		  //mc_viewInBrowserButton
		  
		  //constructor
		  public function PreviewPanel(){			  
			  
			  //set preview data size:
			  mc_previewArea.visible = false;
			  this.dataWidth = this.mc_previewArea.width;
			  this.dataHeight = this.mc_previewArea.height;
			  this.dataX = this.mc_previewArea.x;
			  this.dataY = this.mc_previewArea.y;
			  
			  CommonFunctions.initSimpleButton(this.mc_buttonPrev);
			  CommonFunctions.initSimpleButton(this.mc_buttonNext);
			  CommonFunctions.initSimpleButton(this.mc_buttonClose);
			  CommonFunctions.initSimpleButton(this.mc_viewInBrowserButton);
			  
			  			  
			  //set button events:
			  this.mc_buttonClose.addEventListener(MouseEvent.CLICK,onButtonCloseClick);
			  this.mc_buttonNext.addEventListener(MouseEvent.CLICK,onButtonNextClick);
			  this.mc_buttonPrev.addEventListener(MouseEvent.CLICK,onButtonPrevClick);
			  this.mc_viewInBrowserButton.addEventListener(MouseEvent.CLICK,onViewInBrowserClick);
			  
				// set loaded events:
			  mc_data.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loadProgress);
			  mc_data.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);
			  mc_data.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, loadIOError, false, 0, true);
			  mc_data.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR, loadSecurityError, false, 0, true);			  
		  }
		  
		  
  		  //-------------------------------------------------------------------		  
		  //show the preview panel
		  public function show(){
			  this.visible = true;
		  }
		  
  		  //-------------------------------------------------------------------		  
		  //hide the preview panel
		  public function hide(){
			  this.visible = false;
			  this.mc_data.unload();
		  }
		  
		  
  		  //-------------------------------------------------------------------		  
		  // gets the current item holder
		  public function getCurrentItem(){
			  var item:ItemHolder = this.arrItems[this.currentItemPos];
			  return(item);
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // show and init preloader
		  public function showPreloader(){
			  this.mc_preloader.visible = true;
			  this.mc_preloader.reset();
		  }
		  		  
  		  //-------------------------------------------------------------------		  
		  // hide the preloader
		  public function hidePreloader(){
			  this.mc_preloader.visible = false;
		  }
		  
  		  //-------------------------------------------------------------------		  
		  //view in browser item.
		  public function onViewInBrowserClick(event:MouseEvent){
			  var item:ItemHolder = getCurrentItem();
			  var url = MainClass.urlGalleryActions + "?img=" + item.itemFilename;
			  var req:URLRequest = new URLRequest(url);
			  navigateToURL(req,"_blank");
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // set the load url, and start loading the item data.
		  private function loadItemData(){
			  var item:ItemHolder = getCurrentItem();
			  var req:URLRequest = new URLRequest();
			  
			  switch(item.itemType){
				  case "image":
			  		  req.url = MainClass.urlActions;
					  req.method = "get";
					  var vars:URLVariables = new URLVariables();
					  vars.clientAction = "showimage";
					  vars.img = item.itemFilename;
					  vars.w = this.dataWidth;
					  vars.h = this.dataHeight;
					  req.data = vars;
				  break;
				  default:
				  	trace("loadItemData error - wrong type");
					return(false);
				  break;
			  }
			  			  
			  var website = this.parent;
			  website.setStatus("Loading item: " + this.itemName);
			  
			  showPreloader();
			  this.mc_data.load(req);
		  }
		  
		  //================ loading events: ========================= 
		  
		   private function loadProgress(event:ProgressEvent):void{
			   var website = this.parent;
			   website.setStatus("Loading item: " + this.itemName + " - recieving data");
			   this.mc_preloader.setProgress(event.bytesLoaded,event.bytesTotal);
		   }
		   
		  //--------------------------------------------------
		  // load item completed. position it to it's place. 
		  private function loadComplete(event:Event){
			  var website = this.parent;
			  website.clearStatus();
			  
			  hidePreloader();
			  this.addChild(mc_data);
			  var gap:Number;
			  
			  // place x
			  if(mc_data.width < this.dataWidth){
				  gap = Math.floor((this.dataWidth - mc_data.width)/2);
				  mc_data.x = this.dataX + gap;
			  }
			  else mc_data.x = this.dataX;

			  // place y  			  
			  if(mc_data.height < this.dataHeight){
				  gap = Math.floor((this.dataHeight - mc_data.height)/2);
				  mc_data.y = this.dataY + gap;
			  }
			  else mc_data.y = this.dataY;
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // load error event
		  private function loadIOError(event:IOErrorEvent){			   
		   		trace("load error!!!");
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // load security error event
		  private function loadSecurityError(event:SecurityErrorEvent){
			  trace("load security error!!!");
		  }		  
		  
  		  //-------------------------------------------------------------------		  
		  // set the preview data
		  private function setData(item:ItemHolder,arrItems:Array){
			  	this.arrItems = arrItems;
				var i:Number;
				//set item pos:
				for(i=0;i<arrItems.length;i++){
					if(this.arrItems[i].itemID == item.itemID) this.currentItemPos = i;
				}
				
				this.itemPosOnInit = this.currentItemPos;
				
				this.numItems = arrItems.length;
				
				setCurrentItemData();
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // set the data according current item.
		  private function setCurrentItemData(){
			  //set next and prev pos
			  this.nextItemPos = -1;
			  this.prevItemPos = -1;			  
			  if(this.currentItemPos > 0) this.prevItemPos = this.currentItemPos-1;
			  if(this.currentItemPos < (this.numItems-1)) this.nextItemPos = this.currentItemPos+1;
			  
			  //find the item
			  var item:ItemHolder = getCurrentItem();
			  this.itemName = item.itemName;
			  
			  selectParentItem();	//select this item on items grid.
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // show the saved data
		  private function showData(){
			  this.txt_name.text = this.itemName;
			  this.txt_numitem.text = String((this.currentItemPos + 1) + " of " + this.numItems);
			  
			  //enable or disable next and prev buttons
			  if(this.nextItemPos == -1) disableButton(this.mc_buttonNext);
			  else enableButton(this.mc_buttonNext);
			  
			  if(this.prevItemPos == -1) disableButton(this.mc_buttonPrev);
			  else enableButton(this.mc_buttonPrev);
			  			  
			  loadItemData();
		  }	
		  
  		  //-------------------------------------------------------------------		  
		  // return if the button is enabled or disabled
		  public function isButtonEnabled(mc_button:MovieClip){
			  if(mc_button.visible == true) return(true);
			  else return(false);
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // enable button
		  public function enableButton(mc_button:MovieClip){			  
		  		if(isButtonEnabled(mc_button) == true) return(false);
		  		mc_button.visible = true;
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // disable button
		  public function disableButton(mc_button:MovieClip){
			    if(isButtonEnabled(mc_button) == false) return(false);
				mc_button.visible = false;
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // set the data and show the item preview
		  public function run(item:ItemHolder,arrItems:Array){			  
			  setData(item,arrItems);
			  showData();
		  }
		  
  		  //-------------------------------------------------------------------		  
		  //tells if the preview panel is active
		  public function isActive(){
			  if(this.visible == true) return(true);
			  else return(false);
		  }
		  
  		  //-------------------------------------------------------------------		  
		  //select current item on parent
		  public function selectParentItem(){
			  var itemID = this.arrItems[this.currentItemPos].itemID;			  
			  var website = this.parent;
			  var editPanel = website.mc_editPanel;			  
			  editPanel.selectItemById(itemID);
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // load next item
		  public function loadNextItem(){
			  if(this.nextItemPos == -1) return(false);
			  this.currentItemPos = this.nextItemPos;
			  setCurrentItemData();
			  showData();
		  }
		  
  		  //-------------------------------------------------------------------		  
		  // load prev item
		  public function loadPrevItem(){
			  if(this.prevItemPos == -1) return(false);
			  this.currentItemPos = this.prevItemPos;
			  setCurrentItemData();
			  showData();			  	
		  }
		  
  		  //-------------------------------------------------------------------		  
		  //close button event. closes the preview panel. set command to edit panel to select the last item
		  private function onButtonCloseClick(event:MouseEvent){			  
			  hide();
		  }
		  
		  //-------------------------------------------------------------------		  
		  //prev button event. load prev item
		  private function onButtonPrevClick(event:MouseEvent){			  
		  	  loadPrevItem();
		  }

		  //-------------------------------------------------------------------		  
		  //next button event. load next item
		  private function onButtonNextClick(event:MouseEvent){
			  loadNextItem();
		  }		  		  
		  
	  }   
  }